/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef MODBUSSERVER_H
#define MODBUSSERVER_H

#include <QMainWindow>
#include <QModbusTcpServer>

//QT_BEGIN_NAMESPACE
//namespace Ui { class ModbusServer; }
//QT_END_NAMESPACE

//class ModbusServer : public QMainWindow
class ModbusServer : public QObject
{
    Q_OBJECT

public:
	ModbusServer(QString modbus_file);
    ~ModbusServer();

public slots:
	void Initialize();
	void set_listen_enable(bool enable);	//TODO namechange or privatize?

	// INPUT REGISTERS
	void handler_generator_ready_get(bool enable);		// TODO
	void handler_RF_enable_get(int intrasys_num, bool enable);
//	void handler_sweep_running_get(int intrasys_num, bool enable);			// TODO
//	void handler_sweep_completed_get(int intrasys_num, bool enable);		// TODO
	void handler_DLL_enable_get(int intrasys_num, bool enable);
	void handler_PWM_settings_get(int intrasys_num, double frequency_hz, int duty_cycle);
//	void handler_Software_PID_get(int intrasys_num, bool enable);			// TODO
	void handler_power_get(int intrasys_num, double power_dbm, double power_watt);
	void handler_PA_power_readings(int intrasys_num, double PA_power_fwd_dbm, double PA_power_rfl_dbm, double PA_s11_loss, double PA_power_fwd_watt, double PA_power_rfl_watt, double PA_s11_ratio);
	void handler_frequency_get(int intrasys_num, double frequency_mhz);
	void handler_SWP_measurement_get(int intrasys_num, QString SWP_raw_data);
	void handler_SWP_settings_get(int intrasys_num, double frequency_start, double frequency_stop, double frequency_step, double power_dbm, double power_watt);
	void handler_temperature_get(int intrasys_num, double temperature);
	void handler_error_get(int intrasys_num, quint64 error, QStringList error_messages);
	void handler_datalogging_enable_get(bool enable);
	void handler_datalogging_storage_sufficient(bool enable);
	void handler_PSU_enable_combined_get(int intrasys_num, bool enable);
	void handler_PSU_IU_get(int intrasys_num, int psu_num, double voltage, double current, double power);
	void handler_PSU_dissipation_get(int intrasys_num, double dissipation);
	void handler_PSU_power_efficiency_get(int intrasys_num, double efficiency);
	void handler_SGx_communication_working_get(bool working);
	void handler_PSU_communication_working_get(bool working);
	void handler_get_phase(int intrasys_num, double phase_degrees);
	void handler_get_clock_source(int intrasys_num, int clock_source);
	void handler_get_PGB_phase(int intrasys_num, int pg_channel_num, double phase);

	// HOLDING REGISTERS
	void handler_set_commands(quint16 lastVal, quint16 newVal);
	void handler_set_power_watt(quint16 value);
	void handler_set_frequency(quint16 value);
	void handler_set_SWP_frequency_start(quint16 value);
	void handler_set_SWP_frequency_stop(quint16 value);
	void handler_set_SWP_frequency_step(quint16 value);
	void handler_set_SWP_power(quint16 value);
	void handler_set_DLL_frequency_limit_lower(quint16 value);
	void handler_set_DLL_frequency_limit_upper(quint16 value);
	void handler_set_DLL_frequency_start(quint16 value);
	void handler_set_DLL_frequency_step(quint16 value);
	void handler_set_DLL_threshold(quint16 value);
	void handler_set_DLL_delay(quint16 value);
	void handler_set_PWM_frequency(quint16 value);
	void handler_set_PWM_duty_cycle(quint16 value);
	void handler_set_PID_Kp(quint16 value);
	void handler_set_PID_Ki(quint16 value);
	void handler_set_PID_Kd(quint16 value);
	void handler_set_PID_setpoint(quint16 value);
	void handler_set_PID_scaling_factor(quint16 value);
	void handler_set_PID_offset(quint16 value);
    void handler_set_phase(quint16 value);
    void handler_set_clock_source(quint16 value);
	void handler_set_PGB_phase(quint16 pg_channel_num, quint16 value);


private slots:
	void handleDeviceError(QModbusDevice::Error newError);
	void onConnectedStateChanged(int state);
	void Holding_Register_Update_Handler(QModbusDataUnit::RegisterType table, int address, int size);

private:
	QMap <QString, QString> modbus_map;
	QMap <QString, double> multiplier_map;
	QModbusTcpServer *mbServer;
	QModbusTcpServer *lastServer;
//	QModbusDataUnitMap last_regs;

	void setRegister(QModbusDataUnit::RegisterType reg_type, quint16 address, quint16 value);
	void setInputRegister(quint16 address, quint16 value);
	void setHoldingRegister(quint16 address, quint16 value);

	quint16 getRegister(QModbusDataUnit::RegisterType reg_type, quint16 address);
	quint16 getInputRegister(quint16 address);
	quint16 getHoldingRegister(quint16 address);

	void setBit(quint16 &reg_value, quint16 bit_pos, bool enable);
	void setRegisterBit(QModbusDataUnit::RegisterType reg_type, quint16 address, quint16 bit_pos, bool enable);
	void setInputRegisterBit(quint16 address, quint16 bit_pos, bool enable);
	void setHoldingRegisterBit(quint16 address, quint16 bit_pos, bool enable);

	bool getRegisterBit(QModbusDataUnit::RegisterType reg_type, quint16 address, quint16 bit_pos);
	bool getInputRegisterBit(quint16 address, quint16 bit_pos);
	bool getHoldingRegisterBit(quint16 address, quint16 bit_pos);

signals:
	void signal_modbus_connected_enable(bool enable, QString address, int port, QString error);

	void signal_set_RF_enable(int intrasys_num, bool enable);
	void signal_execute_reset_SGx(int intrasys_num);
	void signal_execute_reset_protection(int intrasys_num);
	void signal_execute_error_clear(int intrasys_num);
	void signal_execute_sweep(int intrasys_num, double freq_start, double freq_stop, double freq_step, double pow_dbm);	//New Sweep Function needed (all in one)
	void signal_set_DLL_enable(int intrasys_num, bool enable);
	void signal_set_PWM_enable(int intrasys_num, bool enable);
	void signal_PSU_interlock(bool enable);
	void signal_execute_restart_program();
//	void signal_PID_enable(int intrasys_num);		//New feature

	void signal_set_power_watt(int intrasys_num, double val);
	void signal_set_frequency(int intrasys_num, double val);
	void signal_set_SWP_frequency_start(int intrasys_num, double val);
	void signal_set_SWP_frequency_stop(int intrasys_num, double val);
	void signal_set_SWP_frequency_step(int intrasys_num, double val);
	void signal_set_SWP_power(int intrasys_num, double val);

	void signal_set_DLL_frequency_limit_lower(int intrasys_num, double val);
	void signal_set_DLL_frequency_limit_upper(int intrasys_num, double val);
	void signal_set_DLL_frequency_start(int intrasys_num, double val);
	void signal_set_DLL_frequency_step(int intrasys_num, double val);
	void signal_set_DLL_threshold(int intrasys_num, double val);
	void signal_set_DLL_delay(int intrasys_num, double val);

	void signal_set_PWM_frequency(int intrasys_num, double val);
	void signal_set_PWM_duty_cycle(int intrasys_num, int val);

	void signal_set_PID_Kp(int intrasys_num, double val);
	void signal_set_PID_Ki(int intrasys_num, double val);
	void signal_set_PID_Kd(int intrasys_num, double val);
	void signal_set_PID_setpoint(int intrasys_num, double val);
	void signal_set_PID_scaling(int intrasys_num, double val);
	void signal_set_PID_offset(int intrasys_num, double val);

    void signal_set_phase(int intrasys_num, double val);
    void signal_set_clock_source(int intrasys_num, int val);

	void signal_set_PGB_phase(int intrasys_num, int PGB_channel_num, double val);

	void signal_set_datalogging_enable(bool enable);
	void signal_set_power_control_mode(int intrasys_num, int mode);
};

#endif // MODBUSSERVER_H
